unit UnitMm1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, AXmsCtrl_TLB, StdCtrls, ShellAPI;

type
  TFormMm1 = class(TForm)
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    Label1: TLabel;
    ComboDevice: TComboBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    EditResult: TEdit;
    EditResponse: TEdit;
    EditLogfile: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    ButtonLoadCfg: TButton;
    ButtonSaveCfg: TButton;
    EditAPN: TEdit;
    EditGateway: TEdit;
    EditLogin: TEdit;
    EditPassword: TEdit;
    EditServer: TEdit;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    ButtonSend: TButton;
    EditTo: TEdit;
    EditSubject: TEdit;
    EditBody: TMemo;
    EditImage: TEdit;
    ButtonBrowse: TButton;
    ButtonView: TButton;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    function GetResult : Integer;
    procedure FormCreate(Sender: TObject);
    procedure ButtonViewClick(Sender: TObject);
    procedure ButtonSendClick(Sender: TObject);
    procedure ButtonLoadCfgClick(Sender: TObject);
    procedure ButtonSaveCfgClick(Sender: TObject);
    procedure ButtonBrowseClick(Sender: TObject);
    function GetTempDirectory: string;
   private
    objConnection : IMmsProtocolMm1;
    objMessage    : IMmsMessage;
    objSlide      : IMmsSlide;
    objConstants  : IMmsConstants;
  public
    { Public declarations }
  end;

var
  FormMm1: TFormMm1;

implementation

{$R *.dfm}
{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm1.FormCreate(Sender: TObject);
var i : Integer;
begin
  objConnection    := TMmsProtocolMm1.Create(Application).DefaultInterface;
  objMessage       := TMmsMessage.Create(Application).DefaultInterface;
  objSlide         := TMmsSlide.Create(Application).DefaultInterface;
  objConstants     := TMmsConstants.Create(Application).DefaultInterface;

  for i := 0 to objConnection.GetDeviceCount () - 1 do begin
    ComboDevice.Items.Add(objConnection.GetDevice(i));
    ComboDevice.ItemIndex := 0;
  end;

  GetTempDirectory ();
end;

{ //////////////////////////////////////////////////////////////////////////////// }

function TFormMm1.GetResult : Integer;
begin
  Result := objConnection.LastError;

  EditResponse.Text   := objConnection.ProviderResponse;
  EditResult.Text     := 'ERROR ' + IntToStr ( Result ) +  ' : ' + objConnection.GetErrorDescription( Result );
end;

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm1.ButtonViewClick(Sender: TObject);
var LogFile : PAnsiChar;
begin
  LogFile := StrNew(PChar(EditLogfile.Text));

  ShellExecute ( 0, 'open' , LogFile, '', '', SW_SHOW )
end;

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm1.ButtonSendClick(Sender: TObject);
var vtVar : OleVariant;
begin
  ButtonSend.Enabled := False;
  Cursor := crHourGlass;

  { Set Connection Properties }
  objConnection.Device              := ComboDevice.Text;
  objConnection.ProviderMMSC        := EditServer.Text;
  objConnection.ProviderAPN         := EditAPN.Text;
  objConnection.ProviderWAPGateway  := EditGateway.Text;
  objConnection.ProviderAPNAccount  := EditLogin.Text;
  objConnection.ProviderAPNPassword := EditPassword.Text;
  objConnection.LogFile             := EditLogfile.Text;

  { Set Message Properties }
  objMessage.AddRecipient (EditTo.Text, objConstants.asMMS_RECIPIENT_TO);
  objMessage.Subject                := EditSubject.Text;

  { Create First Slide }
  vtVar := 0;

  objSlide.AddText(EditBody.Text);
  objSlide.AddAttachment (EditImage.Text, vtVar );

  vtVar := objSlide;
  objMessage.AddSlide(vtVar);

  vtVar := objMessage;

  { Connect to server and send message }
  objConnection.Connect();

  if ( GetResult () = 0 ) then begin
      objConnection.Send(vtVar);
      GetResult ();
      objConnection.Disconnect();
  end;

  ButtonSend.Enabled := True;
  Cursor := crDefault;

end;

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm1.ButtonLoadCfgClick(Sender: TObject);
begin
  OpenDialog.DefaultExt := '.mm1';
  OpenDialog.Filter     := 'MMS Connection Files|*.mm1';

  if OpenDialog.Execute = true Then begin
    objConnection.ProviderLoadConfig (OpenDialog.FileName);

    if ( GetResult() = 0) then begin
      EditServer.Text              := objConnection.ProviderMMSC;
      EditAPN.Text                 := objConnection.ProviderAPN;
      EditGateway.Text             := objConnection.ProviderWAPGateway;
      EditLogin.Text               := objConnection.ProviderAPNAccount;
      EditPassword.Text            := objConnection.ProviderAPNPassword;
    end;
  end;
end;

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm1.ButtonSaveCfgClick(Sender: TObject);
begin
  SaveDialog.DefaultExt := '.mm1';
  SaveDialog.Filter     := 'MMS Connection Files|*.mm1';

  if SaveDialog.Execute = true then begin
    objConnection.ProviderMMSC        := EditServer.Text;
    objConnection.ProviderAPN         := EditAPN.Text;
    objConnection.ProviderWAPGateway  := EditGateway.Text;
    objConnection.ProviderAPNAccount  := EditLogin.Text;
    objConnection.ProviderAPNPassword := EditPassword.Text;

    objConnection.ProviderSaveConfig(SaveDialog.FileName);

    GetResult ();
  end;
end;

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm1.ButtonBrowseClick(Sender: TObject);
begin
  OpenDialog.DefaultExt := '.jpg';
  OpenDialog.Filter     := 'Image Files|*.jpg';

  if OpenDialog.Execute = true Then begin
    EditImage.Text := OpenDialog.FileName;
  end;
end;

{ //////////////////////////////////////////////////////////////////////////////// }

function TFormMm1.GetTempDirectory: string;
var Buffer: array[0..MAX_PATH] of Char;
begin
  GetTempPath(SizeOf(Buffer) - 1, Buffer);
  EditLogfile.Text := StrPas(Buffer) + 'MmsLog.txt';
end;

{ //////////////////////////////////////////////////////////////////////////////// }

end.
